﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace MenuAddCheckBox
{
    public class ToolStripCheckBoxMenuItem : ToolStripControlHost
    {
        public ToolStripCheckBoxMenuItem(string str)
            : base(new CheckBox(), str)
        {
            this.Control.Text = str;
        }
        public string TxtName
        {
            get { return (Control as CheckBox).Text; }
            set { (Control as CheckBox).Text = value; }
        }
        public CheckBox CheckBoxControl
        {
            get { return Control as CheckBox; }
        }
        public CheckState checkState
        {
            get { return ((CheckBox)this.Control).CheckState; }
            set { ((CheckBox)this.Control).CheckState = value; }
        }
        protected override void OnSubscribeControlEvents(Control c)
        {
            base.OnSubscribeControlEvents(c);
            CheckBox checkBox = (CheckBox)c;
            checkBox.CheckStateChanged += new EventHandler(checkBox_CheckStateChanged);
        }
        
       
        
        
        public static ContextMenuStrip newMenuStrip()
        {
            ContextMenuStrip ContxtmnStrip = new ContextMenuStrip();
            ToolStripCheckBoxMenuItem Compiled = new ToolStripCheckBoxMenuItem("Compiled");
            Compiled.ToolTipText = "正規表現をコンパイルしてアセンブリを作成することを指定します。\nこれにより実行速度は速くなりますが、起動にかかる時間は長くなります。";
            ToolStripCheckBoxMenuItem CultureInvariant = new ToolStripCheckBoxMenuItem("CultureInvariant");
            CultureInvariant.ToolTipText = "言語の違いが無視されるように指定します。";
            ToolStripCheckBoxMenuItem ECMAScript = new ToolStripCheckBoxMenuItem("ECMAScript");
            ECMAScript.ToolTipText = "式の ECMAScript 準拠の動作を有効にします。\nこの値は、必ず IgnoreCase、Multiline、Compiled の各値と組み合わせて使用します。\nその他の値と組み合わせて使用すると、例外が発生します。 ";
            ToolStripCheckBoxMenuItem ExplicitCapture = new ToolStripCheckBoxMenuItem("ExplicitCapture");
            ExplicitCapture.ToolTipText = "明示的に名前または番号を指定された (?<name>...) の形式のグループだけが\n有効なキャプチャであることを指定します。\nこれにより、名前のないかっこは表現 (?:...) に構文上の間違いがなくても、非キャプチャ グループとして機能するようになります。 ";
            ToolStripCheckBoxMenuItem IgnoreCase = new ToolStripCheckBoxMenuItem("IgnoreCase");
            IgnoreCase.ToolTipText = "検索時に大文字と小文字を区別しないことを指定します。";
            ToolStripCheckBoxMenuItem IgnorePatternWhitespace = new ToolStripCheckBoxMenuItem("IgnorePatternWhitespace");
            IgnorePatternWhitespace.ToolTipText = "パターンからエスケープが解除された空白を削除し、# でマークされたコメントを有効にします。\n ただし、IgnorePatternWhitespace 値は 文字クラス内の空白には影響しないため、文字クラスから空白が削除されることはありません。 ";
            ToolStripCheckBoxMenuItem Multiline = new ToolStripCheckBoxMenuItem("Multiline");
            Multiline.ToolTipText = "複数行モードを指定します。\n^ と $ の意味を変更して、文字列全体の先頭と末尾だけでなく、任意の行の先頭と末尾にもそれぞれが一致するようにします。 ";
            ToolStripCheckBoxMenuItem RightToleft = new ToolStripCheckBoxMenuItem("RightToLeft");
            RightToleft.ToolTipText = "検索が左から右ではなく右から左に行われるように指定します。";
            ToolStripCheckBoxMenuItem Singleline = new ToolStripCheckBoxMenuItem("Singleline");
            Singleline.ToolTipText = @"単一行モードを指定します。\n ??????????????????????????????? (.) ?????????? ";
            
            
            ContxtmnStrip.Items.AddRange(new ToolStripItem[]{Compiled,CultureInvariant,ECMAScript,
                ExplicitCapture,IgnoreCase,IgnorePatternWhitespace,Multiline,RightToleft,Singleline});
            return ContxtmnStrip;
        }
        void checkBox_CheckStateChanged(object sender, EventArgs e)
        {
            Invalidate();
            if (CheckChanged != null)
            {
                CheckChanged(this, e);
            }

        }
        public event EventHandler CheckChanged;
      

    }
}
